/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWExpressionTextField;
import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class VWReturnParamPanel
extends JPanel
implements IVWExpressionTextFieldListener {
    private GridBagConstraints m_gbCons = null;
    protected VWToolbarBorder m_returnBorder = null;
    protected VWExpressionTextField m_returnTextField = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInstructionDefinition m_instructionDef = null;

    public void init(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.initReturnControls();
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        this.m_instructionDef = instructionDef;
        this.m_returnTextField.removeExpressionTextFieldListener(this);
        if (this.m_instructionDef != null) {
            this.m_returnTextField.setText(VWInstruction.ReturnInstructionGetRetryOption(this.m_instructionDef));
        } else {
            this.m_returnTextField.setText("");
        }
        this.m_returnTextField.addExpressionTextFieldListener(this);
    }

    private void initReturnControls() {
        this.m_returnBorder = new VWToolbarBorder(VWResource.s_returnExpressionStr, 0);
        JPanel clientPanel = this.m_returnBorder.getClientPanel();
        clientPanel.setLayout(new GridLayout(1, 1));
        this.m_returnTextField = new VWExpressionTextField(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData);
        this.m_returnTextField.addExpressionTextFieldListener(this);
        clientPanel.add(this.m_returnTextField);
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 2;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.m_returnBorder, this.m_gbCons);
    }

    public void textUpdated(VWExpressionTextFieldEvent event) {
        Object src = event.getSource();
        if (src == this.m_returnTextField) {
            this.updateReturnExpression();
        }
    }

    private void updateReturnExpression() {
        try {
            String returnExpression = this.m_returnTextField.getText();
            VWInstruction.ReturnInstructionSetRetryOption(this.m_instructionDef, returnExpression);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

